| package |
package := Package name: 'CU Browser Database UI'.
package paxVersion: 1;
	basicComment: 'Copyright  Chris Uppal, 2001-2005.
chris.uppal@metagnostic.org

A *very* simple GUI to control and monitor the Browser Database.

The terms under which you may use this software are:
	You must not claim that you wrote it.
	You must not claim that you own it.
	You use it at your own risk.

I''d appreciate it if you didn''t distribute modified versions without at least trying to tell me about the changes you thought worthwhile.

	-- chris
'.

package basicPackageVersion: '1.041'.

package basicScriptAt: #postinstall put: '(Package manager packageNamed: ''CU Browser Database UI'')
	propertyAt: #ExternalResourceFileNames
	put: #(
		''Resources\GoPauseStopBar.bmp''
	).
!!'.

package classNames
	add: #BrowserDatabaseShell;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: 'CU Browser Database';
	add: 'CU PackageResourceLocator';
	add: 'CU Sortblocks';
	add: 'CU Tools Base';
	add: '..\Object Arts\Dolphin\Base\Dolphin';
	add: '..\Object Arts\Dolphin\MVP\Views\Common Controls\Dolphin Common Controls';
	add: '..\Object Arts\Dolphin\MVP\Views\Control Bars\Dolphin Control Bars';
	add: '..\Object Arts\Dolphin\MVP\Models\List\Dolphin List Models';
	add: '..\Object Arts\Dolphin\MVP\Presenters\List\Dolphin List Presenter';
	add: '..\Object Arts\Dolphin\MVP\Base\Dolphin MVP Base';
	yourself).

package!

"Class Definitions"!

CUToolShell subclass: #BrowserDatabaseShell
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

"End of package definition"!

"Source Globals"!

"Classes"!

BrowserDatabaseShell guid: (GUID fromString: '{53902BC0-7A4A-4639-BE69-8A8EBF350216}')!
BrowserDatabaseShell comment: 'Copyright  Chris Uppal, 2003 - 2005.
chris.uppal@metagnostic.org
'!
!BrowserDatabaseShell categoriesForClass!Unclassified! !
!BrowserDatabaseShell methodsFor!

createComponents
	"private -- create subpresenters for our various subviews"

	super createComponents.

	self add: (Presenter new) name: 'Toolbar'.
	self add: (ListPresenter new) name: 'StatusList'.
!

disableBDB
	"command -- disable the Browser Database"

	| ok |

	ok := MessageBox
		confirm: 'Are you sure you wish to discard the current browser database ?'
		caption: 'Discard Browser Database'.

	ok ifTrue: [Cursor wait showWhile: [self model beDisabled]].!

model: aBrowserDatabase
	"set the model for this presenter, this is expected to be a BrowserDatabase"

	self model removeEventsTriggeredFor: self.

	super model: aBrowserDatabase.

	self model
		when: #stateChanged send: #onStateChanged to: self;
		when: #statisticsChanged send: #onStatisticsChanged to: self.

	self onStatisticsChanged.!

onStateChanged
	"private -- the browser database has just changed state"

	self toolbarPresenter view invalidateUserInterface.!

onStatisticsChanged
	"private -- the browser database has just changed its stats"

	| list |

	list := self model isEnabled
		ifTrue: [self model stats associations]
		ifFalse: [#()].
	self statusListPresenter list: (list asSortedCollection: (SortStringsAscending by: #key)).
	self statusListPresenter view isEnabled: list notEmpty.

	self onStateChanged.
!

pauseBDB
	"command -- disable the Browser Database"

	| ok |

	ok := MessageBox
		confirm: 'Are you sure you wish to pause the browser database ?'
		caption: 'Pause Browser Database'.

	ok ifTrue: [Cursor wait showWhile: [self model bePaused]].!

queryCommand: aCommandQuery
	"private -- set the enabledness etc of aCommandQuery"

	| cmd enabled checked |

	super queryCommand: aCommandQuery.
	cmd := aCommandQuery command.
	enabled := aCommandQuery isEnabled.
	checked := aCommandQuery isChecked.

	cmd == #runBDB ifTrue: [checked := self model isRunning].
	cmd == #pauseBDB ifTrue: [checked := self model isPaused. enabled := self model isEnabled].
	cmd == #stopBDB ifTrue: [checked := self model isStopped. enabled := self model isEnabled].
	cmd == #disableBDB ifTrue: [checked := self model isDisabled].

	aCommandQuery isEnabled: enabled.
	aCommandQuery isChecked: checked.
!

refreshStats
	"command -- update the stats display"

	self onStatisticsChanged.!

runBDB
	"command -- start the Browser Database"

	| ok |

	ok := MessageBox
		confirm: 'Are you sure you wish to run/resume the browser database ?'
		caption: 'Run Browser Database'.

	ok ifTrue: [Cursor wait showWhile: [self model beRunning]].!

shrinkBDB
	"command -- ask the BDB to optimise the space used by its internal tables"

	Cursor wait showWhile: [self model shrink].
!

statusListPresenter
	"private -- answer the presenter named 'StatusList'"

	^ self presenterNamed: 'StatusList'.
!

stopBDB
	"command -- stop (update then freeze) the Browser Database"

	| ok |

	ok := MessageBox
		confirm: 'Are you sure you wish to freeze the browser database ?'
		caption: 'Freeze Browser Database'.

	ok ifTrue: [Cursor wait showWhile: [self model beStopped]].!

toolbarPresenter
	"private -- answer the presenter named 'Toolbar'"

	^ self presenterNamed: 'Toolbar'.
! !
!BrowserDatabaseShell categoriesFor: #createComponents!initializing!private!subpresenters! !
!BrowserDatabaseShell categoriesFor: #disableBDB!commands!public! !
!BrowserDatabaseShell categoriesFor: #model:!accessing!initializing!models!public! !
!BrowserDatabaseShell categoriesFor: #onStateChanged!event handling!private! !
!BrowserDatabaseShell categoriesFor: #onStatisticsChanged!event handling!private! !
!BrowserDatabaseShell categoriesFor: #pauseBDB!commands!public! !
!BrowserDatabaseShell categoriesFor: #queryCommand:!commands!private! !
!BrowserDatabaseShell categoriesFor: #refreshStats!commands!public! !
!BrowserDatabaseShell categoriesFor: #runBDB!commands!public! !
!BrowserDatabaseShell categoriesFor: #shrinkBDB!commands!public! !
!BrowserDatabaseShell categoriesFor: #statusListPresenter!private!subpresenters! !
!BrowserDatabaseShell categoriesFor: #stopBDB!commands!public! !
!BrowserDatabaseShell categoriesFor: #toolbarPresenter!private!subpresenters! !

!BrowserDatabaseShell class methodsFor!

about
	"answer a string very briefly describing ourself"

	^ 'Browser Database Status Monitor.  Version 1.
Copyright  Chris Uppal, 2003-2005.
chris.uppal@metagnostic.org'.!

bugs
	"answer a String describing the less than outstanding work"

	^ 'Confirmation prompts are kinda wierd sometimes.
'.!

defaultModel
	"answer a default model to be assigned to the receiver when it is initialized"

	^ BrowserDatabase current.!

help
	"answer a string describing ourselves"

	^ '
Displays and controls the status of the Browser Database.

	-- chris
'.
!

initialize
	"private -- class-side initialisation.

		self initialize.
	"

	self reuseIfOpen: self superclass reuseIfOpen.
	self registerAsTool.
!

resource_Default_view
	"Answer the literal data from which the 'Default view' resource can be reconstituted.
	DO NOT EDIT OR RECATEGORIZE THIS METHOD.

	If you wish to modify this resource evaluate:
	ViewComposer openOn: (ResourceIdentifier class: self selector: #resource_Default_view)
	"

	^#(#'!!STL' 3 788558 10 ##(Smalltalk.STBViewProxy)  8 ##(Smalltalk.ShellView)  98 27 0 0 98 2 27131905 131073 416 0 524550 ##(Smalltalk.ColorRef)  8 4278190080 328198 ##(Smalltalk.Point)  601 621 517 0 0 0 416 788230 ##(Smalltalk.BorderLayout)  1 1 410 8 ##(Smalltalk.Toolbar)  98 25 0 416 98 2 8 1140851468 131137 592 0 482 512 0 517 0 263174 ##(Smalltalk.Font)  0 16 459014 ##(Smalltalk.LOGFONT)  8 #[243 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 65 114 105 97 108 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0] 530 193 193 0 592 482 512 8 4294902231 234 256 98 0 234 256 832 202 208 832 234 240 832 0 1 0 530 33 33 530 45 45 0 656198 1 ##(Smalltalk.FlowLayout)  1 1 1 983302 ##(Smalltalk.MessageSequence)  202 208 98 2 721670 ##(Smalltalk.MessageSend)  8 #createAt:extent: 98 2 530 1 1 530 585 51 592 1026 8 #updateSize 832 592 983302 ##(Smalltalk.WINDOWPLACEMENT)  8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 36 1 0 0 25 0 0 0] 98 1 410 608 98 25 0 592 98 2 8 1140853580 131137 1216 0 482 512 0 517 0 690 0 16 722 8 #[243 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 3 2 1 34 65 114 105 97 108 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0] 530 193 193 0 1216 482 512 8 4294902231 234 256 832 234 256 98 8 26621 853766 ##(Smalltalk.ToolbarButton)  26621 0 1216 13 1180998 4 ##(Smalltalk.CommandDescription)  8 #pauseBDB 8 'Temporarily stop updating the database' 1 1 0 395334 3 ##(Smalltalk.Bitmap)  0 16 1442310 ##(Smalltalk.PackageResourceLocator)  8 'CU Browser Database UI' 8 'Resources/' 8 'GoPauseStopBar.bmp' 0 0 7 530 161 33 3 26623 1442 26623 0 1216 13 1474 8 #stopBDB 8 'Make the database a frozen snapshot of the current system' 1 1 0 1552 5 26625 1442 26625 0 1216 13 1474 8 #disableBDB 8 'Discard the database' 1 1 0 1552 9 26619 1442 26619 0 1216 13 1474 8 #runBDB 8 'Update the database as methods are changed' 1 1 0 1552 1 98 5 1792 1456 1664 1728 1050118 ##(Smalltalk.ToolbarSeparator)  0 0 1216 3 0 1 234 240 98 2 1552 1 0 1 0 530 33 33 530 45 45 0 930 1 1 1 962 202 208 98 2 1026 1056 98 2 530 1 1 530 201 51 1216 1026 1136 832 1216 1154 8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 100 0 0 0 25 0 0 0] 98 0 530 193 193 0 27 2160 0 27 0 0 0 410 8 ##(Smalltalk.ListView)  98 30 0 416 98 2 8 1140953165 1025 2176 590662 2 ##(Smalltalk.ListModel)  202 208 832 0 1114638 ##(Smalltalk.STBSingletonProxy)  8 ##(Smalltalk.SearchPolicy)  8 #identity 482 512 0 5 0 0 0 2176 0 8 4294902173 8 ##(Smalltalk.BasicListAbstract)  0 2314 8 ##(Smalltalk.IconImageManager)  8 #current 0 0 0 0 0 0 202 208 98 2 920646 5 ##(Smalltalk.ListViewColumn)  8 '' 351 8 #left 2400 8 ##(Smalltalk.SortedCollection)  459270 ##(Smalltalk.Message)  8 #key 98 0 0 2176 0 1 0 0 2498 8 '' 227 2544 2400 2560 2578 8 #value 2624 0 2176 0 3 0 0 8 #report 832 0 131137 0 0 962 202 208 98 1 1026 1056 98 2 530 1 51 530 585 515 2176 1154 8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 25 0 0 0 36 1 0 0 26 1 0 0] 98 0 2160 0 27 234 256 98 4 2176 8 'StatusList' 592 8 'Toolbar' 0 461638 4 ##(Smalltalk.MenuBar)  0 16 98 5 265030 4 ##(Smalltalk.Menu)  0 16 98 1 984134 2 ##(Smalltalk.CommandMenuItem)  1 1474 8 #exit 8 '&Close' 16615 1 0 0 0 8 '&File' 0 1 0 0 26581 0 0 2994 0 16 98 1 3042 1 1474 8 #refreshStats 8 '&Refresh stats' 233 1 0 0 0 8 '&View' 0 1 0 0 26585 0 0 2994 0 16 98 4 3042 1025 1474 1824 8 '&Run normally' 1 1 0 0 0 3042 1025 1474 1504 8 '&Pause updates' 1 1 0 0 0 3042 1025 1474 1696 8 '&Freeze' 1 1 0 0 0 3042 1025 1474 1760 8 '&Disable' 1 1 0 0 0 8 '&Run' 0 1 0 0 26595 0 0 2994 0 16 98 3 3042 1 1474 8 #shrinkBDB 8 '&Shrink' 1 1 0 0 0 983366 1 ##(Smalltalk.DividerMenuItem)  4097 2994 0 16 98 4 3042 1 1474 8 #toggleTopMost 8 'Always on &Top' 8361 1 0 0 0 3586 4097 3042 1 1474 8 #rememberWindowSize 8 '&Remember this size' 1 1 0 0 0 3042 1 1474 8 #forgetWindowSize 8 '&Forget size' 1 1 0 0 0 8 '&Options' 0 1 0 0 26605 0 0 8 '&Tools' 0 1 0 0 26607 0 0 2994 0 16 98 6 3042 1 1474 8 #help 8 '&Help on this tool' 225 1 0 0 0 3586 4097 3042 1 1474 8 #helpAbout 8 '&About this tool' 1 1 0 0 0 3586 4097 3042 1 1474 8 #bugs 8 '&Bugs' 1 1 0 0 0 3042 1 1474 8 #todo 8 '&Todo' 1 1 0 0 0 8 '&Help' 0 1 0 0 26617 0 0 8 '' 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 962 202 208 98 3 1026 1056 98 2 530 309 407 530 601 621 416 1026 8 #text: 98 1 8 'Browser Database' 416 1026 8 #updateMenuBar 832 416 1154 8 #[44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 154 0 0 0 203 0 0 0 198 1 0 0 1 2 0 0] 98 2 592 2176 2160 0 27 )!

todo
	"answer a String describing the outstanding work"

	^ '
Revisit class update code now that metaclasses use #become: (if they do ??).
'.!

uninitialize
	"private -- class tear-down.

		self uninitialize.
	"

	self unRegisterAsTool.! !
!BrowserDatabaseShell class categoriesFor: #about!documentation!public! !
!BrowserDatabaseShell class categoriesFor: #bugs!documentation!public! !
!BrowserDatabaseShell class categoriesFor: #defaultModel!models!public! !
!BrowserDatabaseShell class categoriesFor: #help!documentation!public! !
!BrowserDatabaseShell class categoriesFor: #initialize!development!initializing!private! !
!BrowserDatabaseShell class categoriesFor: #resource_Default_view!public!resources-views! !
!BrowserDatabaseShell class categoriesFor: #todo!documentation!public! !
!BrowserDatabaseShell class categoriesFor: #uninitialize!development!initializing!private! !

"Binary Globals"!

